/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.apps.taskman.toolkit.dialog;

import filenet.pe.ceutils.ConnectionPoint;
import filenet.vw.apps.taskman.VWTaskCore;
import filenet.vw.apps.taskman.VWTaskUtil;
import filenet.vw.apps.taskman.resources.VWResource;
import filenet.vw.base.VWDebug;
import filenet.vw.base.VWString;
import filenet.vw.toolkit.utils.VWHelp;
import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.vw.toolkit.utils.dialog.VWModalDialog;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.io.PrintWriter;
import java.io.StringWriter;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.Border;

public class VWConnectionPointDialog
extends VWModalDialog
implements ActionListener,
FocusListener {
    private int m_closeStatus = 1;
    private String m_helpPath = null;
    private JButton m_okButton = null;
    private JButton m_cancelButton = null;
    private JButton m_helpButton = null;
    private JComboBox m_connectionPoints = null;
    private JTextField m_peNameField = null;
    private JTextField m_regionField = null;
    private Border m_textBorder = null;

    public VWConnectionPointDialog(ConnectionPoint[] cps, String defaultConnectionPoint) throws Exception {
        this(cps, defaultConnectionPoint, null, null, null);
    }

    public VWConnectionPointDialog(ConnectionPoint[] cps, String defaultConnectionPoint, String title, String okButtonTxt, String helpPath) {
        super(VWTaskCore.getInstance().getMainFrame());
        if (title == null) {
            title = VWResource.SelectConnectionPoint;
        }
        if (okButtonTxt == null) {
            okButtonTxt = VWResource.OK;
        }
        this.m_helpPath = helpPath;
        this.m_connectionPoints = cps != null ? new JComboBox<ConnectionPoint>(new DefaultComboBoxModel<ConnectionPoint>(cps)) : new JComboBox();
        this.m_connectionPoints.addActionListener(this);
        this.m_connectionPoints.setRenderer(new DefaultListCellRenderer(){

            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                return super.getListCellRendererComponent((JList<?>)list, value != null ? ((ConnectionPoint)value).Name : "", index, isSelected, cellHasFocus);
            }
        });
        this.initLayout(title, okButtonTxt);
        if (cps != null) {
            ConnectionPoint cp = null;
            if (defaultConnectionPoint != null) {
                for (int i = 0; i < cps.length; ++i) {
                    if (!cps[i].Name.equals(defaultConnectionPoint)) continue;
                    cp = cps[i];
                    break;
                }
            }
            if (cp != null) {
                this.m_connectionPoints.setSelectedItem(cp);
            } else if (cps != null && cps.length > 0) {
                this.m_connectionPoints.setSelectedIndex(0);
            }
        }
    }

    public void performOKAction() throws Exception {
    }

    public int getCloseStatus() {
        return this.m_closeStatus;
    }

    public ConnectionPoint getSelectedConnectionPoint() {
        return (ConnectionPoint)this.m_connectionPoints.getSelectedItem();
    }

    public void actionPerformed(ActionEvent event) {
        Object object = event.getSource();
        if (object == this.m_okButton) {
            this.onOKButton(event);
        } else if (object == this.m_cancelButton) {
            this.onCancelButton(event);
        } else if (object == this.m_helpButton) {
            VWHelp.displayPage(this.m_helpPath);
        } else if (object == this.m_connectionPoints) {
            this.m_peNameField.setText(((ConnectionPoint)this.m_connectionPoints.getSelectedItem()).DNSName);
            this.m_regionField.setText("" + ((ConnectionPoint)this.m_connectionPoints.getSelectedItem()).IsolatedRegionNumber);
        } else {
            JButton defaultButton = this.getRootPane().getDefaultButton();
            defaultButton.doClick();
        }
    }

    private void initLayout(String title, String okButtonTxt) {
        try {
            String dialogDim = new VWString("vw.apps.taskman.toolkit.dialog.VWConnectionPointDialogDim", "350,150").toString();
            Dimension dim = VWStringUtils.stringToDimension(dialogDim);
            if (dim == null) {
                dim = new Dimension(385, 300);
            }
            this.setSize(dim);
            this.setTitle(title);
            this.setVisible(false);
            this.getContentPane().setLayout(new BorderLayout(10, 10));
            this.getContentPane().add((Component)this.getUserInfoPanel(), "Center");
            this.getContentPane().add((Component)this.getButtonControlPanel(okButtonTxt), "Last");
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private JPanel getUserInfoPanel() {
        JPanel p = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 23;
        c.fill = 2;
        c.gridwidth = 1;
        c.insets = new Insets(10, 10, 0, 10);
        c.weighty = 0.0;
        c.weightx = 0.0;
        c.gridx = 0;
        ++c.gridy;
        p.add((Component)new JLabel(VWResource.Label.toString(VWResource.ConnectionPoint)), c);
        c.weighty = 0.0;
        c.weightx = 1.0;
        c.gridx = 1;
        c.insets = new Insets(10, 0, 0, 10);
        p.add((Component)this.m_connectionPoints, c);
        c.insets = new Insets(10, 10, 0, 10);
        c.weighty = 0.0;
        c.weightx = 0.0;
        c.gridx = 0;
        ++c.gridy;
        p.add((Component)new JLabel(VWResource.Label.toString(VWResource.ProcessEngine)), c);
        c.weighty = 0.0;
        c.weightx = 1.0;
        c.gridx = 1;
        c.insets = new Insets(10, 0, 0, 10);
        this.m_peNameField = new JTextField();
        this.m_peNameField.setEditable(false);
        this.m_peNameField.setBorder(null);
        this.m_peNameField.addFocusListener(this);
        p.add((Component)this.m_peNameField, c);
        c.insets = new Insets(10, 10, 0, 10);
        c.weighty = 0.0;
        c.weightx = 0.0;
        c.gridx = 0;
        ++c.gridy;
        p.add((Component)new JLabel(VWResource.Label.toString(VWResource.IsolatedRegion)), c);
        c.weighty = 0.0;
        c.weightx = 1.0;
        c.gridx = 1;
        c.insets = new Insets(10, 0, 0, 10);
        this.m_regionField = new JTextField();
        this.m_regionField.setEditable(false);
        this.m_regionField.setBorder(null);
        this.m_regionField.addFocusListener(this);
        p.add((Component)this.m_regionField, c);
        return p;
    }

    private JPanel getButtonControlPanel(String okButtonTxt) {
        JPanel panel = null;
        try {
            panel = new JPanel();
            panel.setLayout(new FlowLayout());
            if (this.m_okButton == null) {
                this.m_okButton = new JButton(okButtonTxt);
                this.m_okButton.setSelected(true);
                this.m_okButton.addActionListener(this);
            }
            panel.add(this.m_okButton);
            if (this.m_cancelButton == null) {
                this.m_cancelButton = new JButton(VWResource.Cancel);
                this.m_cancelButton.addActionListener(this);
            }
            panel.add(this.m_cancelButton);
            if (this.m_helpButton == null && this.m_helpPath != null) {
                this.m_helpButton = new JButton(VWResource.Help);
                this.m_helpButton.addActionListener(this);
                panel.add(this.m_helpButton);
            }
            if (this.getRootPane() != null) {
                this.getRootPane().setDefaultButton(this.m_okButton);
            }
            return panel;
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            return null;
        }
    }

    private void onOKButton(ActionEvent event) {
        final VWConnectionPointDialog thisComponent = this;
        Runnable runnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    VWTaskUtil.showWaitCursor(true, thisComponent);
                    VWConnectionPointDialog.this.performOKAction();
                    VWConnectionPointDialog.this.m_closeStatus = 0;
                    VWConnectionPointDialog.this.setVisible(false);
                }
                catch (Exception ex) {
                    StringWriter stackTrace = new StringWriter();
                    ex.printStackTrace(new PrintWriter(stackTrace));
                    VWString msg = new VWString("filenet.vw.apps.taskman.toolkit.dialog.VWConnectionPointDialogExceptionMsg", "{1} \n\nError Details:\n{0}", ex.getMessage(), stackTrace.toString());
                    VWTaskCore.getInstance().displayError(msg.toString());
                }
                finally {
                    VWTaskUtil.showWaitCursor(false, thisComponent);
                }
            }
        };
        new Thread(runnable).start();
    }

    private void onCancelButton(ActionEvent event) {
        try {
            this.m_closeStatus = 1;
            this.setVisible(false);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void focusGained(FocusEvent e) {
        Object source = e.getSource();
        if (source instanceof JTextField && !((JTextField)source).isEditable() || source instanceof JTextArea && !((JTextArea)source).isEditable()) {
            this.m_textBorder = ((JComponent)source).getBorder();
            ((JComponent)source).setBorder(BorderFactory.createEtchedBorder());
        }
    }

    public void focusLost(FocusEvent e) {
        Object source = e.getSource();
        if (source instanceof JTextField && !((JTextField)source).isEditable() || source instanceof JTextArea && !((JTextArea)source).isEditable()) {
            ((JComponent)source).setBorder(this.m_textBorder);
        }
    }
}

